package orthogonalstate;

import java.util.*;
//import nestedstate.tools.*;

public class NodeState extends State
{
        Vector childnodes = new Vector();
        State currentstate = null;
        State defaultstate = null;
        
        public NodeState(String s)
        { 
                super(s);
        }

        /**
        * Adds a transition with this state as source and parameter to as a
        * target. Since this is a node state what really happens is that all the 
        * child nodes get a transaction to the target state with the action. 
        * @param trigger The event that triggers the transition
        * @param to The target state.
        * @param action The associated action
        */
        public void addTransition(LeafState to,
                                  FSMEvent trigger,                                    
                                  FSMAction action)
        {                                               
                for(Enumeration e = childnodes.elements();e.hasMoreElements();)
                {
                        ((State)e.nextElement()).addTransition(to,trigger,
                                                               action);
                }
        }

        /**
        * Adds a transition with this state as source and parameter to as a
        * target. Since this is a node state what really happens is that all the 
        * child nodes get a transaction to the target state with the action. 
        * @param trigger The event that triggers the transition
        * @param to The target state.
        * @param action The associated action
        */
        public void addTransition(NodeState to,
                                  FSMEvent trigger,                                    
                                  FSMAction action)
        {
                for(Enumeration e = childnodes.elements();e.hasMoreElements();)
                {
                        ((State)e.nextElement()).addTransition(to,trigger,
                                                               action);
                }
        }
        
        public void addTransition(Vector to,
                                  FSMEvent trigger,                                    
                                  FSMAction action)
        {
                for(Enumeration e = childnodes.elements();e.hasMoreElements();)
                {
                        ((State)e.nextElement()).addTransition(to,trigger,
                                                               action);
                }
        }
        
        /**
        * A nodestate must know what states it has. 
        */
        public void addState(State s)
        {
                s.setParent(this);
                childnodes.addElement(s);
        }
      
        /**
        * Sets the state s as the current state. If s is a NodeState, is the 
        * default LeafState is found recursively first. Then that LeafState is 
        * set as the current state for it's parent and that parent is set as the 
        * current state for the parent's parent, etc. All the way up to the
        * root.
        */
        public void setState(State s)
        {
                if(s instanceof LeafState)
                {
                        setState2(s);            
                }
                else if(s instanceof NodeState)
                {
                        LeafState ls = getLowestDefaultLeaf((NodeState)s);
                        ls.getParent().setState2(ls); 
                }
        }
        
        void setState2(State s)
        {
                NodeState p = getParent();
                if(p!=null)
                        p.setState2(this);
                currentstate = s;
        }
                
        /**
        * @return the current state. 
        */
        public State getState() { return currentstate; }
        
        /**
        * Find out what the lowest default leaf is. Each NodeState has a default
        * state. If this default state is a NodeState, it is asked recursively
        * for its lowest default leaf state.
        * @return The lowest default leaf.
        */
        public static LeafState getLowestDefaultLeaf(LeafState l)
        {
                return l;
        }
        
        /**
        * Find out what the lowest default leaf is. Each NodeState has a default
        * state. If this default state is a NodeState, it is asked recursively
        * for its lowest default leaf state.
        * @return The lowest default leaf.
        */
        public static LeafState getLowestDefaultLeaf(NodeState n)
        {
                State d = n.getDefaultState();
                // look recursively
                if(d instanceof NodeState)
                        return getLowestDefaultLeaf((NodeState)d);
                else if(d instanceof LeafState)
                        return (LeafState)d;
                return null;
        }
                
        
        public void setDefaultState(State s) { defaultstate = s; }
        public State getDefaultState() { return defaultstate; } 
        
        /**
        * Dispatch an event. Since this is a node state, this means dispatch it
        * to the current state of the embedded machine. This state knows how to
        * handle the event.
        * @param trigger The event that needs to be dispatched. The correct 
        * transition is located and than executed.
        * @param data Some additional data that may be needed by the action
        * @param fsmc The context in which the action is executed. This may be 
        * useful for retrieving global variables.
        */
        public void dispatch(FSMEvent trigger, 
                                      Object data, 
                                      FSMContext fsmc)
        {
                getState().dispatch(trigger, data, fsmc);
        }
        
        /**
        * Method to find out which events can be dispatched by this state.
        * @return A vector with the events 
        */
        public Vector getEvents()
        {
                return getState().getEvents();
        }
        
        /**
        * @return a string describing the current state in the form 
        * name->childname->child's childname-> ... 
        */
        public String toString()
        {
                return getName() + "->" + getState();
        }
}